/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.analysis.core;

import java.io.IOException;
import org.apache.lucene.ars_nouveau.analysis.TokenFilter;
import org.apache.lucene.ars_nouveau.analysis.TokenStream;
import org.apache.lucene.ars_nouveau.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.ars_nouveau.analysis.util.StemmerUtil;

public final class DecimalDigitFilter
extends TokenFilter {
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);

    public DecimalDigitFilter(TokenStream input) {
        super(input);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            char[] buffer = this.termAtt.buffer();
            int length = this.termAtt.length();
            for (int i = 0; i < length; ++i) {
                int ch = Character.codePointAt(buffer, i, length);
                if (ch <= 127 || !Character.isDigit(ch)) continue;
                buffer[i] = (char)(48 + Character.getNumericValue(ch));
                if (ch <= 65535) continue;
                length = StemmerUtil.delete(buffer, i + 1, length);
                this.termAtt.setLength(length);
            }
            return true;
        }
        return false;
    }
}

